/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network;

import com.ibm.hwmca.base.settings.SettingsConstants;
import com.ibm.hwmca.base.settings.network.NetAppFirewallRule;
import com.ibm.hwmca.base.settings.network.NetworkInterfaceInformation;
import com.ibm.hwmca.base.settings.network.config.NetworkApplicationConfig;
import com.ibm.hwmca.base.settings.network.config.NetworkSettingsConfig;
import com.ibm.hwmca.base.settings.network.config.PortConfig;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class FirewallBean
extends PanelBean
implements SettingsConstants {
    private String m_sOtherPorts;
    private String m_sLanAddr;
    private ColumnDescriptor[] m_cdFirewallPotentialsStructure;
    private int[] m_iFirewallPotentialsSelection;
    private String m_sPorts;
    private ColumnDescriptor[] m_cdFirewallSelectionsStructure;
    private int[] m_iFirewallSelectionsSelection;
    private ArrayList firewallSelections;
    private NetworkSettingsConfig netConfig;
    private NetworkApplicationConfig[] netApps;
    private NetworkInterfaceInformation netif;
    private Integer netifIndex;
    private String bundleName;
    private static final String TRACE_MASKT = "XSETFWBT";
    private static final String TRACE_MASKF = "XSETFWBF";
    private static final String TRACE_MASKD = "XSETFWBD";

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public ColumnDescriptor[] getFirewallPotentialsRowStructure() {
        return this.m_cdFirewallPotentialsStructure;
    }

    public int getFirewallPotentialsRowStatus() {
        return 3;
    }

    public int getFirewallPotentialsRowCount() {
        return this.netApps.length;
    }

    public ItemDescriptor[] getFirewallPotentialsRowAt(int index) {
        ItemDescriptor[] item = new ItemDescriptor[2];
        if (index < this.netApps.length) {
            item[0] = new ItemDescriptor("one" + index, this.netApps[index].getName());
            StringBuffer sb = new StringBuffer();
            PortConfig[] ports = this.netApps[index].getPortsArray();
            for (int j = 0; j < ports.length; ++j) {
                sb.append(ports[j].getNumber());
                sb.append(":");
                switch (ports[j].getType()) {
                    case 1: {
                        sb.append("tcp");
                        break;
                    }
                    case 2: {
                        sb.append("udp");
                        break;
                    }
                    case 3: {
                        sb.append("icmp");
                    }
                }
                sb.append(" ");
            }
            item[1] = new ItemDescriptor("two" + index, sb.toString());
        }
        return item;
    }

    public void setFirewallPotentialsRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
    }

    public int[] getFirewallPotentialsSelection() {
        return this.m_iFirewallPotentialsSelection;
    }

    public void setFirewallPotentialsSelection(int[] selected) throws IllegalUserDataException {
        this.m_iFirewallPotentialsSelection = selected;
    }

    public String getPorts() {
        return this.m_sPorts;
    }

    public void setPorts(String s) throws IllegalUserDataException {
        this.m_sPorts = s;
    }

    public ColumnDescriptor[] getFirewallSelectionsRowStructure() {
        return this.m_cdFirewallSelectionsStructure;
    }

    public int getFirewallSelectionsRowStatus() {
        return 3;
    }

    public int getFirewallSelectionsRowCount() {
        return this.firewallSelections.size();
    }

    public ItemDescriptor[] getFirewallSelectionsRowAt(int index) {
        ItemDescriptor[] item = new ItemDescriptor[3];
        if (index < this.firewallSelections.size()) {
            NetAppFirewallRule rule = (NetAppFirewallRule)this.firewallSelections.get(index);
            String name = this.netConfig.getNetApp(rule.getAppId()).getName();
            item[0] = new ItemDescriptor("1" + index, name);
            item[1] = new ItemDescriptor("2" + index, rule.getPort());
            item[2] = new ItemDescriptor("3" + index, rule.getSourceAddr() + "/" + rule.getSourceAddrMask());
        } else {
            item = new ItemDescriptor[]{new ItemDescriptor(), new ItemDescriptor(), new ItemDescriptor()};
        }
        return item;
    }

    public void setFirewallSelectionsRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
    }

    public int[] getFirewallSelectionsSelection() {
        return this.m_iFirewallSelectionsSelection;
    }

    public void setFirewallSelectionsSelection(int[] selected) throws IllegalUserDataException {
        this.m_iFirewallSelectionsSelection = selected;
    }

    public String getLanAddr() {
        return this.m_sLanAddr;
    }

    public void setLanAddr(String s) throws IllegalUserDataException {
        this.m_sLanAddr = s;
    }

    public String getOtherPorts() {
        return this.m_sOtherPorts;
    }

    public void setOtherPorts(String s) throws IllegalUserDataException {
        this.m_sOtherPorts = s;
    }

    public void load() {
        this.m_sOtherPorts = "";
        this.m_cdFirewallPotentialsStructure = new ColumnDescriptor[0];
        this.m_iFirewallPotentialsSelection = new int[1];
        this.m_sPorts = "";
        this.m_cdFirewallSelectionsStructure = new ColumnDescriptor[0];
        this.m_iFirewallSelectionsSelection = new int[1];
    }

    public void prepare() {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.bundleName);
            for (int i = 0; i < this.netApps.length; ++i) {
                this.netApps[i].setResourceBundle(bundle);
            }
        }
        catch (MissingResourceException e) {
            Trace.trace(TRACE_MASKF, e);
        }
        if (this.netApps.length == 0) {
            this.userTaskManager.setEnabled(this.getMountPrefix() + "addFirewall", false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "addByIPAddr", false);
        }
        this.userTaskManager.setShown(this.getMountPrefix() + "Group2", false);
    }

    public void setNetConfig(NetworkSettingsConfig netConfig) {
        this.netConfig = netConfig;
        this.netApps = netConfig.getNetAppsArray();
        this.bundleName = netConfig.getResourceBundleName();
    }

    public void setNetworkInterface(NetworkInterfaceInformation netif, Integer netifIndex) {
        this.netif = netif;
        this.netifIndex = netifIndex;
        String macAddr = netif.getMacAddress();
        StringBuffer sb = new StringBuffer();
        int len = macAddr.length();
        for (int i = 0; i < len && i < 24; i += 2) {
            sb.append(macAddr.substring(i, i + 2));
            if (i >= len - 2) continue;
            sb.append(":");
        }
        sb.append(" ");
        sb.append(SettingsConstants.CARDTYPES[netif.getAdapterType()]);
        this.m_sLanAddr = sb.toString();
        List rules = netif.getFirewallRules();
        this.firewallSelections = rules != null ? new ArrayList(rules) : new ArrayList();
    }

    public void update(Object data) {
        Trace.trace(TRACE_MASKF, "-> FirewallBean.update");
        ArrayList rules = (ArrayList)data;
        this.firewallSelections.addAll(rules);
        this.userTaskManager.refreshElement(this.getMountPrefix() + "FirewallTable");
        Trace.trace(TRACE_MASKF, "<- FirewallBean.update");
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "FirewallBean.panelAction: event=[" + event + "]");
        String command = event.getElementName();
        if (command.endsWith("addFirewall")) {
            Trace.trace(TRACE_MASKF, "FirewallBean: they hit the 'Allow incoming' button");
            if (this.m_iFirewallPotentialsSelection != null && this.m_iFirewallPotentialsSelection.length > 0) {
                int index = this.m_iFirewallPotentialsSelection[0];
                NetworkApplicationConfig netApp = this.netApps[index];
                StringBuffer sb = new StringBuffer();
                PortConfig[] ports = this.netApps[index].getPortsArray();
                String protocol = "tcp";
                switch (ports[0].getType()) {
                    case 1: {
                        protocol = "tcp";
                        break;
                    }
                    case 2: {
                        protocol = "udp";
                        break;
                    }
                    case 3: {
                        protocol = "icmp";
                    }
                }
                for (int j = 0; j < ports.length; ++j) {
                    sb.append(ports[j].getNumber());
                    if (j + 1 == ports.length) continue;
                    sb.append(",");
                }
                String portString = sb.toString();
                NetAppFirewallRule rule = new NetAppFirewallRule(netApp.getApplicationID(), this.netif.getIfname(), "0.0.0.0", "0.0.0.0", protocol, portString);
                if (this.firewallSelections.contains(rule)) {
                    try {
                        CommonMsgApp.showMessageBox(this.userTaskManager, new LocalizableText("Already allowed"), new BaseMessageText("SETFW003I", new String[]{protocol, portString}), MsgType.INFORMATION_MESSAGE);
                    }
                    catch (HException hexc) {
                        Trace.trace(TRACE_MASKF, hexc);
                    }
                } else {
                    this.firewallSelections.add(rule);
                }
                this.userTaskManager.refreshElement(this.getMountPrefix() + "FirewallTable");
            }
        } else if (command.endsWith("addByIPAddr")) {
            Trace.trace(TRACE_MASKF, "FirewallBean: they hit the 'Allow Incoming by IP Address' button");
            if (this.m_iFirewallPotentialsSelection != null && this.m_iFirewallPotentialsSelection.length > 0) {
                int index = this.m_iFirewallPotentialsSelection[0];
                NetworkApplicationConfig netApp = this.netApps[index];
                StringBuffer sb = new StringBuffer();
                PortConfig[] ports = this.netApps[index].getPortsArray();
                String protocol = "tcp";
                switch (ports[0].getType()) {
                    case 2: {
                        protocol = "udp";
                        break;
                    }
                    case 1: {
                        protocol = "tcp";
                        break;
                    }
                    case 3: {
                        protocol = "icmp";
                    }
                }
                for (int j = 0; j < ports.length; ++j) {
                    sb.append(ports[j].getNumber());
                    if (j + 1 == ports.length) continue;
                    sb.append(",");
                }
                String portString = sb.toString();
                NetAppFirewallRule rule = new NetAppFirewallRule(netApp.getApplicationID(), this.netif.getIfname(), "0.0.0.0", "0.0.0.0", protocol, portString);
                if (this.firewallSelections.contains(rule)) {
                    try {
                        CommonMsgApp.showMessageBox(this.userTaskManager, new LocalizableText("Already allowed"), new BaseMessageText("SETFW003I", new String[]{protocol, portString}), MsgType.INFORMATION_MESSAGE);
                    }
                    catch (HException hexc) {
                        Trace.trace(TRACE_MASKF, hexc);
                    }
                } else {
                    PanelTaskletRequest request = new PanelTaskletRequest("firewallpanel");
                    request.setData("panel", "firewallpanel");
                    request.setData("action", "addByIPAddr");
                    String[] parms = new String[]{netApp.getApplicationID(), netApp.getName(), this.netif.getIfname(), this.netif.getIpAddress().getHostAddress(), protocol, portString, this.m_sLanAddr};
                    request.setData("data", parms);
                    this.postTaskletRequest(request);
                }
            }
        } else if (command.endsWith("removeFirewall")) {
            Trace.trace(TRACE_MASKF, "FirewallBean: they hit the 'Remove' button");
            if (this.m_iFirewallSelectionsSelection != null && this.m_iFirewallSelectionsSelection.length > 0 && this.m_iFirewallSelectionsSelection[0] < this.firewallSelections.size()) {
                this.firewallSelections.remove(this.m_iFirewallSelectionsSelection[0]);
                this.userTaskManager.refreshElement(this.getMountPrefix() + "FirewallTable");
            }
        }
    }

    public void parentalAction(TaskActionEvent event, PanelBean parent) {
        String command = event.getElementName();
        Trace.trace(TRACE_MASKF, "FirewallBean: received a parental action: " + event.getElementName());
        if (command.endsWith("detailsOkButton")) {
            Trace.trace(TRACE_MASKT, "FirewallBean: They hit ok.");
            ArrayList rules = new ArrayList(this.firewallSelections);
            this.netif.setFirewallRules(rules);
            PanelTaskletRequest request = new PanelTaskletRequest("firewallpanel");
            request.setData("panel", "firewallpanel");
            request.setData("dataupdates", this.netif);
            request.setData("data", this.netifIndex);
            this.postTaskletRequest(request);
        } else if (command.endsWith("detailsCancelButton")) {
            // empty if block
        }
    }
}

